/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric;

import com.llamalad7.mixinextras.sugar.Local;
import dev.architectury.event.events.common.EntityEvent;
import net.minecraft.class_1593;
import net.minecraft.class_2338;
import net.minecraft.class_2910;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2910.class)
public abstract class MixinPhantomSpawner {
    
    @Inject(
            method = "tick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/EntityType;create(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/EntitySpawnReason;)Lnet/minecraft/world/entity/Entity;",
                    ordinal = 0,
                    shift = At.Shift.BY,
                    by = 3
            ),
            cancellable = true
    )
    private void checkPhantomSpawn(class_3218 level, boolean bl, CallbackInfo ci, @Local(ordinal = 1) class_2338 pos, @Local class_1593 entity) {
        if (EntityEvent.LIVING_CHECK_SPAWN.invoker().canSpawn(entity, level, pos.method_10263(), pos.method_10264(), pos.method_10260(), class_3730.field_16459, null).value() == Boolean.FALSE) {
            ci.cancel();
        }
    }
}
