/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.mixin.fabric;

import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.hooks.fabric.PersistentEntitySectionManagerHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.lang.ref.WeakReference;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_5568;
import net.minecraft.class_5579;

@Mixin(class_5579.class)
public class MixinPersistentEntitySectionManager<T extends class_5568> implements PersistentEntitySectionManagerHooks {
    @Unique
    private WeakReference<class_3218> levelRef;
    
    @Override
    public void architectury_attachLevel(class_3218 level) {
        levelRef = new WeakReference<>(level);
    }
    
    @Inject(method = "addEntity", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/core/SectionPos;asLong(Lnet/minecraft/core/BlockPos;)J"),
            cancellable = true)
    private void addEntity(T entityAccess, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        // TODO: Check if other classes implements EntityAccess as well
        if (entityAccess instanceof class_1297 entity && levelRef != null) {
            var level = levelRef.get();
            levelRef = null;
            
            if (level != null) {
                if (EntityEvent.ADD.invoker().add(entity, level).isFalse()) {
                    cir.setReturnValue(false);
                }
            }
        }
    }
}
