/*
 * This file is part of architectury.
 * Copyright (C) 2020, 2021, 2022 architectury
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package dev.architectury.hooks.item.tool.fabric;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1794;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public class HoeItemHooksImpl {
    public static void addTillable(class_2248 input, Predicate<class_1838> predicate, Consumer<class_1838> action, Function<class_1838, class_2680> newState) {
        if (class_1794.field_8023 instanceof ImmutableMap) {
            class_1794.field_8023 = new HashMap<>(class_1794.field_8023);
        }
        class_1794.field_8023.put(input, new Pair<>(predicate, useOnContext -> {
            action.accept(useOnContext);
            class_2680 state = newState.apply(useOnContext);
            useOnContext.method_8045().method_8652(useOnContext.method_8037(), state, 11);
        }));
    }
}
